c23456789012345678901234567890123456789012345678901234567890123456789012
c        1         2         3         4         5         6         7
c      KO see Springer book by Wilkins, M.
c              "Computer simulations of Dynamic Phenomena"
       parameter(jj = 170)       !total number of nodes allowed
                                 !this number should be greater than the number
                                 !of nodes that you want so that nodes can be added
                                 !if fracture occurs
       parameter(jmat=7)        !number of materials
       parameter(nmax=4)        !number of placeholders for time: t(0) and t(1) current, t(2) and t(3) new
       integer n, j,imat,ibc(0:jj), icontact,idebug,jdebug,iskip,ipoint
       integer j1(jj),iEOS(2,jj),jjj,jzz,ndebug
       integer icompact(0:nmax,jj)
       real*8  m(0:jj), r(0:nmax,0:jj), U(0:nmax,0:jj)
       real*8  t(0:nmax),pfrac(0:jj),pvoid
       real*8  phi(0:nmax,0:jj), sigmar(0:nmax,0:jj)
       real*8  sigmao(0:nmax,0:jj)
       real*8  beta(0:nmax,0:jj), P(0:nmax,0:jj), q(0:nmax,0:jj)
       real*8  s1(0:nmax,0:jj),s2(0:nmax,0:jj), s3(0:nmax,0:jj)
       real*8  rho(0:jj), V(0:nmax,0:jj)
       real*8  epsi1(0:nmax,0:jj), epsi2(0:nmax,0:jj)
       real*8  E(0:nmax,0:jj), K(0:nmax,0:jj), Y(0:jj)
       real*8  deltaZ, Vdot ,dt_min, dr_min,delt_temp
       real*8  deltar,  qbar
       real*8  b, Co, CL, d
       real*8  EOS(jmat,9),init(jmat,4),bc(-9:9,5),LL(jj),xstart(jj)
       real*8  xx,xa,xb,deltat_0,deltat,delt,tstop
c       real*8  U_0,P_0,V_0,E_0,rho_0,a_0,up
c       real*8  U_1,P_1,V_1,E_1,a,
       real *8 a,zero
       real*8  aa,ww,rr,bb,dti0,dti1,Usave
       real*8  phiv,phij,betav,betaj,dthalf
       real*8 qtotal,mvtotal,etotal
       real*8 bs1,bs2,bs3,bs4,bs5,bs6,bs7,bs8,bs9
       real*8 tskip,dtskip
       real*8 rho_local,stemp,ctemp,gtemp,v0,v00,vv

       character*20 name
       character*120 text
c
c     Initalize some key varables
       Co        = 2.0d0                   !artifical viscoity constants
       CL        = 1.0d0                   !artifical viscoity constants
       pvoid     = 0.d0
       iskip     = 10000
       icontact  = 0   !contact flag this should not be changed but i think it could
                     ! be elimated if the code were cleaned up.
       idebug    = 0     !turn on debug
       ndebug    = 1  !what time steup to you want to print to screen
       jdebug    = 2  ! what node do you want to look at
       d         = 1.d0   !defines geometry, see willkins
c       deltat_0 = 0.05d0*(L1/dfloat(JJ1))/sqrt(P_1/rho_0/V_1)
       deltat_0  = 1.d-3
       tskip     = 0.d0   !this is the value at which data starts getting written to file
       dtskip    = 100.d0  !This is the amount of time skipped between writes
       tstop     = 1.d-1 !this line can be deleted, tstop now comes from ko.in
c
c     zero all variables
c
      print *,'Initializing variables ...'
       zero = 0.d0
       do n = 0,nmax
          do j = 0,jj
             ibc(j)      = 9
             U(n,j)      = zero
             t(n)        = deltat_0*dfloat(n)
             deltat      = deltat_0
             phi(n,j)    = zero
             sigmar(n,j) = zero
             sigmao(n,j) = zero
             beta(n,j)   = zero
             q(n,j)      = zero
             s1(n,j)     = zero
             s2(n,j)     = zero
             s3(n,j)     = zero
             epsi1(n,j)  = zero
             epsi2(n,j)  = zero
             K(n,j)      = zero
             Y(j)        = zero
             deltaZ      = zero
             pfrac(j)    = zero
           enddo
       enddo
c
      do j=1,jmat
       do i=1,7
        eos(j,i)= 0.d0
       enddo
       do i=1,4
        init(j,i)= 0.d0
       enddo
      enddo
      do j=1,jj
       do jzz=1,2
        ieos(jzz,j)= 0
       enddo
      enddo
c
c     Read input Data file
c
      print *,'running'
c      pause
      imat = 0
      jsum = 0
      name='ko.dat'
      open (unit=33, file=name, form='formatted', status='unknown')
      open (unit=31, file='ko.in', form='formatted',status='unknown')
      print *,'opned file'
c      pause
      Read(31,'(A120)') text
      print *,text
      Read(31,'(A120)') text
      print *,text
c      pause
 5    imat=imat+1
      print *,'reading',imat
c      pause
      Read(31,'(A120)') text
      print *,Text
             print *,'testing text'
c             pause
      if(text(1:7) .eq. '       ') goto 6
      print *,'text passed.'
      iEOS(1,jj-(imat-1)) = imat
      Read(text,'(2I7,6e7,3e9,6e7)')
     & iEOS(2,jj-(imat-1)),j1(imat),LL(imat),xstart(imat),
     & init(imat,1),init(imat,2),init(imat,3),
     & init(imat,4),
     & eos(imat,1),eos(imat,2),eos(imat,3),eos(imat,4),
     & eos(imat,5),eos(imat,6),eos(imat,7),eos(imat,8),eos(imat,9)
      if ( int(j1(imat)/2) .ne. float(j1(imat))/2.) then
       print *,'Error: number of nodes specificed in ko.in must be even'
c       pause
      endif
      jsum = jsum + j1(imat)
      if (jsum .ge. jj) then
       print *,'Error: Increase jj or reduce the number nodes in ko.in'
       pause
      endif
      print *,'data at j',imat,eos(imat,7)
      print *,'gg',eos(imat,4)
      print *,
     & iEOS(1,jj-(imat-1)),
     & iEOS(2,jj-(imat-1)),j1(imat),LL(imat),xstart(imat),
     & init(imat,1),init(imat,2),init(imat,3),
     & init(imat,4),
     & eos(imat,1),eos(imat,2),eos(imat,3),eos(imat,4),
     & eos(imat,5),eos(imat,6),eos(imat,7),eos(imat,8),eos(imat,9)
c      pause
      goto 5
 6    Print *,'End of material data input file...'
      imat = imat-1
c      pause
      Read(31,'(A113)') text
      print *,text
c      pause
      Read(31,'(A113)') text
      print *,text
c      pause
      Read(31,'(A113)') text
      print *,text
      Read(text,'(I7,5e7)')
     & ibc(0),bc(-1,1),bc(-1,2),bc(-1,3),bc(-1,4),bc(-1,5)
      print *,'read data...',ibc(0)
c      pause
      Read(31,'(A113)') text
      print *,text
      Read(text,'(I7,5e7)')
     & jjj,bc( 1,1),bc( 1,2),bc( 1,3),bc( 1,4),bc( 1,5)
      print *,'read data...',bc( 1,1)
c
      Read(31,'(A113)') text
      print *,text
      Read(31,'(A113)') text
      print *,text
      Read(31,'(A113)') text
      print *,text
      Read(text,'(e20)') tstop
      close(31)
c
c      Distritazation LOOP
c
      print *,'distrize ..'
c      pause
        r(0,1) = xstart(1)
        r(1,1) = xstart(1)
       do jjj=1,imat
       print *,'distrize ..',jjj
c       pause
       deltar = Ll(jjj)/dfloat(j1(jjj)/2)
       write(*,'(a6,1x,3e24.16)') 'deltar',deltar
c       pause
       if (jjj .eq. 1) then
        ipoint = 0
       elseif (abs(r(0,ipoint+j1(jjj-1))-xstart(jjj)) .lt. 1.e-5) then
c       no gap between materials
        r(0,ipoint+j1(jjj-1)) = xstart(jjj)
        r(1,ipoint+j1(jjj-1)) = xstart(jjj)
        ibc(ipoint+j1(jjj-1)) = 0
        ipoint                = ipoint+j1(jjj-1)
       elseif ( r(0,ipoint+j1(jjj-1)) .lt. xstart(jjj)) then
c       inital gap between materials
        ipoint      = ipoint+j1(jjj-1)+2
        ibc(ipoint  ) = -2
        ieos(2,ipoint-1)= 0
        ibc(ipoint-2) =  2
       else
       print *,'Input Geometry Error!'
       pause
       endif
c
          r(0,ipoint)  = xstart(jjj)
          r(1,ipoint)  = xstart(jjj)
          ibc(1)       = 0
          U(0,ipoint)  = init(jjj,2)
          U(1,ipoint)  = init(jjj,2)
       do j=ipoint+2,ipoint+j1(jjj),2      !node definitions
          ibc(j)       = 0
          r(0,j)       = r(0,j-2) + deltar
          r(1,j)       = r(1,j-2) + deltar
          U(0,j)       = init(jjj,2)
          U(1,j)       = init(jjj,2)
       enddo
c       pause
       do j=ipoint+1,ipoint+j1(jjj)-1,2    !cell definitions
          ibc(j)       = 0
          r(0,j)       = 0.5d0*(r(0,j+1)+r(0,j-1))
          r(1,j)       = 0.5d0*(r(1,j+1)+r(1,j-1))
          P(0,j)       = init(jjj,1)
          P(1,j)       = init(jjj,1)
          rho(j)       = init(jjj,3)  !rho is not updated in time therefore it is always rho0
          E(0,j)       = init(jjj,4)
          E(1,j)       = init(jjj,4)
          ieos(1,j)    = ieos(1,jj-(jjj-1))  !info was stored there (RHS) just temp.
          ieos(2,j)    = ieos(2,jj-(jjj-1))  !info was stored there (RHS) just temp.
          Y(j)         = eos(jjj,5)
          pfrac(j-1)   = eos(jjj,7)
          pfrac(j)     = eos(jjj,7)
          pfrac(j+1)   = eos(jjj,7)
       enddo
          ieos(1,jj-(jjj-1))     = 0
          ieos(2,jj-(jjj-1))     = 0
          ibc(j1(jjj)+ipoint)    = 2
          ibc(j1(jjj)+1+ipoint)  = 9
      enddo
          ibc(j1(imat)+ipoint)    = 1
          print *,ipoint
c
      print *,'assign mass'
c
        do j=0,jj-2,2
             if (ibc(j+1) .eq. 0) then
              m(j+1) = rho(j+1)*((r(0,j+2)**d- r(0,j)**d)/d)
             endif
        enddo
c        pause
c
c set initial specific volume
      do j=0,jj-2,2
       if (ibc(j+1) .eq. 0) then
        V(0,j+1)=rho(j+1)*((r(0,j+2)**d-r(0,j)**d)/d)/m(j+1)
        V(1,j+1)=rho(j+1)*((r(0,j+2)**d-r(0,j)**d)/d)/m(j+1)
        icompact(0,j)  = 0 ! compaction flag for use with snow plow type models initilized to zero
        icompact(1,j)  = 0 ! compaction flag for use with snow plow type models initilized to zero
        icompact(2,j)  = 0 ! compaction flag for use with snow plow type models initilized to zero
       endif
      enddo
c
c     Output Initial Conditions
c
      n=1
      write(*,98)
     &'n','rad','rad','Vel','Vel'
     &,'pres','Vol'
      do j=0,jj-2,2
       write(*,'(I4,0I2,10f15.7)')
     &  j,  !ieos(1,j+1),ieos(2,j+1),
     &  !ibc(j),ibc(j+1),ibc(j+2),
     &  r(n,j),r(n,j+1),r(n,j+2),U(n,j),P(n,j+1)!,
     &  !v(n,j+1),m(j+1),rho(j+1),Y(j+1)
      enddo
c
       print *,'Start Main Loop,  goto tstop = ',tstop
       pause
c
 98   format(2A3,11x,A9,A9,A9,A10,a8)
c99   format(2I3,e9.2,9e9.2,2f7.4,6e9.2)
c
c*****************************************************************************
c******************************** MAIN LOOP **********************************
c*****************************************************************************
c
       ndummy = -1
c       if (t(n) .le. tstop) then
 1      ndummy = ndummy + 2 ! when this use to count to an integer, ndummy was the max integer
        n     =  1    ! this use to be the time step counter when all n data was stored
                      ! n must remain n=1 because the time data is no longer stored
      if( m(1) .ne. m(3) ) then
       print *,'Masses do not match',n,m(1),m(3)
       pause
      endif
c
cccccccccccccccc   Contact Check   ccccccccccccccccccccccc
c
      if (1 .eq. 0) then
      do j=0,jj,2
      if (ibc(j) .ne. 9) then
        delt     =  (t(n+1)-t(n-1))/2.d0
        r(n+2,j) =  r(n,j)+U(n-1,j)*delt*2.0d0
        r(n+1,j) = (r(n,j)+r(n+2,j))/2.d0
      endif
      enddo
c
      do j=2,jj-2,2
        if ( ibc(j) .ne. 9 .and. r(n+2,j) .le. r(n+2,j-2) .and.
     &       ibc(j-1) .eq. 9) then
          icontact = 2
          ibc(j) = -3  !this is a flag to let the contact stuff after the
                       ! momentum step know that
                       ! the delta t was recaclulated so that the two nodes
                       ! that are about to collide will touch perfectely after
                       ! this time step.
         print *,'Contact Eminent!',n,j
         print *,'Previous half Time step',t(n)-t(n-1)
         print *,'For time step 2 x Deltat',2.d0*delt
         Print *,' Estimated collision:'
         print *,'Void Node at ',r(n,j-2),' will move to ',
     &              r(n,j-2)+U(n-1,j-2)*2.d0*deltat
         print *,'Void node velocity',U(n-1,j-2)
         print *,'J Node at ',r(n,j),' will move to ',
     &              r(n,j)  +U(n-1,j  )*2.d0*delt
         print *,'J node velocity',U(n-1,j)

        jjv       = j-2
        jjj       = j
        ww        = U(n-1,jjj) - U(n-1,jjv)
        rr        = r(n  ,jjj) - r(n  ,jjv)
c
c this is the ibc(j)= 1 for the inside (v) side of the boundary
        sigmar(n,jjv-1) = (-(P(n,jjv-1)+q(n-1,jjv-1))+s1(n,jjv-1))
        sigmao(n,jjv-1) = (-(P(n,jjv-1)+q(n-1,jjv-1))+s2(n,jjv-1))
      phiv      = (rho(jjv-1)*((r(n,jjv)-r(n,jjv-2))/V(n,jjv-1)))/2.d0
        betav     = (sigmar(n,jjv-1)-sigmao(n,jjv-1))*V(n,jjj-1)/
     &              (r(n,jjv-1)*rho(jjv-1))
c this is the ibc(j)=-1 for the outside (j) side of the boundary
        sigmar(n,jjj+1) = (-(P(n,jjj+1)+q(n-1,jjj+1))+s1(n,jjj+1))
        sigmao(n,jjj+1) = (-(P(n,jjj+1)+q(n-1,jjj+1))+s2(n,jjj+1))
      phij      = (rho(jjj+1)*((r(n,jjj+2)-r(n,jjj))/V(n,jjj+1)))/2.d0
        betaj     = (sigmar(n,jjj+1)-sigmao(n,jjj+1))*V(n,jjj+1)/
     &              (r(n,jjj+1)*rho(jjj+1))
c
      aa = sigmar(n,jjj+1)/phij + sigmar(n,jjv-1)/phiv
     &   + (betav + betaj)*(d-1.d0)
      dthalf = t(n) - t(n-1)
      bb   = (2.d0*ww + aa * dthalf)
      dti0 = 0.d0
      dti1 = dti0-(aa*dti0*dti0+bb*dti0+2.d0*rr)/(2.d0*aa*dti0+bb)
      print *,'sig',sigmar(n,jjj+1),phij,sigmar(n,jjv-1),phiv
      print *,'bet',betav,betaj,d
      print *,aa,bb,rr,ww
      print *,rho(jjv-1),r(n,jjv),r(n,jjv-2),V(n,jjv-1)
      print *,rho(jjj+1),r(n,jjj+2),r(n,jjj),V(n,jjj+1)
      print *,'betav',sigmar(n,jjv-1),sigmao(n,jjv-1),
     &  r(n,jjj),r(n,jjj-2),V(n,jjj-1),rho(jjj-1)
c
      jj1=0
      do while (abs(dti1-dti0) .gt. 1.d-16)
      jj1 = jj1 + 1
      dti0 = dti1
      dti1 = dti0-(aa*dti0*dti0+bb*dti0+2.d0*rr)/(2.d0*aa*dti0+bb)
      print *,aa,bb,rr,ww
      print *,'iteration',dti0,dti1
      if (jj1 .gt.1) pause
      enddo
      print *,'Whole Time step adjusted from ',2.d0*delt
      deltat = dti1/2.d0                            !this might need to be adjusted because i changed the way time steping works
      print *,'To ',(deltat+dti1)
      print *,'where ',dti1,' is the time to impact'
      print *,'and ',deltat,' is an arbatrary small number.'
       pause
       endif !contact if
      enddo
       pause
      endif   !contact check if
c
ccccccccccccccccccccccc  Advance Time step  cccccccccccccccccccccccccccccc
c
c     advance time step, for first calculation timestep is set by deltat_0
c     after that the time step is calculated after the end of the current time step, deltat
c
      if (icontact .eq. 2) then      ! if there was contact time step adjusted to perfectly
         t(n+1) = t(n) + dti1/2.d0   ! have nodes touch at the end of the time step
         t(n+2) = t(n+1) + deltat
         icontact = 0
         if  (dti1 - deltat .lt. 0. .or. t(n+2)-t(n+1) .lt. 0.) then
          print *,'Time step Error from contact'
          print *, dti1,deltat,dti1 - deltat , t(n+2)-t(n+1)
 10       pause
          go to 10
         endif
      else
         t(n+1) = t(n) + deltat/2.d0
         t(n+2) = t(n) + deltat
      endif
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     2.    Conservation of Momumtum  - start j
c
      do j=0,jj,2
      if (ibc(j+1) .eq. 0) then
       sigmar(n,j+1) = (-(P(n,j+1)+q(n-1,j+1))+s1(n,j+1))
       sigmao(n,j+1) = (-(P(n,j+1)+q(n-1,j+1))+s2(n,j+1))
      endif
      enddo
c
      do j=0,jj,2
c
       delt = t(n+1)-t(n-1)    !this is different than deltat, deltat is the true timestep
      if (ibc(j) .ne. 9) then

       if (ibc(j) .eq. -1) then
        phi(n,j) = (rho(j+1)*((r(n,j+2)-r(n,j))/V(n,j+1)))/2.d0
        beta(n,j) = (sigmar(n,j+1)-sigmao(n,j+1))*V(n,j+1)
     &             /(r(n,j+1)*rho(j+1))
        U(n+1,j) = U(n-1,j)+(delt/phi(n,j))
     &  *(sigmar(n,j+1)+bc(-1,1))+delt*beta(n,j)*(d-1.d0)

c this is the new way which treats the voids like inner or outer bc's
       elseif (ibc(j) .eq. -2 .or. ibc(j) .eq. -3) then
        phi(n,j) = (rho(j+1)*((r(n,j+2)-r(n,j))/V(n,j+1)))/2.d0
        beta(n,j) = (sigmar(n,j+1)-sigmao(n,j+1))*V(n,j+1)
     &             /(r(n,j+1)*rho(j+1))
        U(n+1,j) = U(n-1,j)+(delt/phi(n,j))
     &  *(sigmar(n,j+1)+pvoid)+delt*beta(n,j)*(d-1.d0)
       elseif (ibc(j) .eq. 2) then
        phi(n,j) =  rho(j-1)*((r(n,j)-r(n,j-2))/V(n,j-1))/2.d0
        beta(n,j) = (sigmar(n,j-1)-sigmao(n,j-1))*V(n,j-1)
     &             /(r(n,j-1)*rho(j-1))
        U(n+1,j) = U(n-1,j)+(delt/phi(n,j))
     &  *(pvoid-sigmar(n,j-1))+delt*beta(n,j)*(d-1.d0)
       elseif (ibc(j) .eq. 0) then
        phi(n,j) = (0.5d0)*(rho(j+1)*((r(n,j+2)-r(n,j))/V(n,j+1))+
     &   rho(j-1)*((r(n,j)-r(n,j-2))/V(n,j-1)))
        beta(n,j)=( (sigmar(n,j+1)-sigmao(n,j+1))*(V(n,j+1)/rho(j+1))/
     &  (0.5d0*(r(n,j+2)+r(n,j  ))) +
     &            (sigmar(n,j-1)-sigmao(n,j-1))*(V(n,j-1)/rho(j-1))/
     &  (0.5d0*(r(n,j  )+r(n,j-2))) )/2.d0
        U(n+1,j) = U(n-1,j)+(delt/phi(n,j))
     &  *(sigmar(n,j+1)-sigmar(n,j-1))+delt*beta(n,j)*(d-1.d0)
       elseif (ibc(j) .eq. 1) then
        phi(n,j) =  rho(j-1)*((r(n,j)-r(n,j-2))/V(n,j-1))/2.d0
        beta(n,j) = (sigmar(n,j-1)-sigmao(n,j-1))*V(n,j-1)
     &             /(r(n,j-1)*rho(j-1))
        U(n+1,j) = U(n-1,j)+(delt/phi(n,j))
     &  *(-bc(1,1)         -sigmar(n,j-1))+delt*beta(n,j)*(d-1.d0)
c       U(n+1,j) = 0.d0
       elseif (ibc(j) .eq. -4) then
        U(n+1,j) = 0.d0
c       if ( U(n+1,j) .lt. 1.d-5) U(n+1,j) = 0.d0
       else
        print *,'Momentum ERROR!!!'
        print *,j,ibc(j)
        pause
       endif
c
      endif
      enddo
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     3.  Position  - within j
c
      do j=0,jj,2
      if (ibc(j) .ne. 9) then
        r(n+2,j) =  r(n,j)+U(n+1,j)*deltat
        r(n+1,j) = (r(n,j)+r(n+2,j))/2.d0
      endif
      enddo
c debug block
        if (idebug .eq. 1 .and. ndummy .ge. ndebug) then
        j=jdebug
        print *,'j=',j,'n=',n,'ndummy=',ndummy
        print *,'time',t(n-1),t(n),t(n+1),t(n+2)
        print *,'deltat',deltat,delt
        print *,'vel',U(n,j),U(n+1,j)
        print *,'r',r(n,j-2),r(n,j),r(n,j+2)
        print *,'V',V(n,j+1),V(n,j),V(n,j-1)
        print *,'rho',rho(j-1),rho(j),rho(j+1)
        print *,'sigmar',sigmar(n,j+1),sigmar(n,j-1)
        print *,'sigmao',sigmao(n,j-1),sigmao(n,j+1)
        print *,'4',phi(n,j),beta(n,j),U(n-1,j)
        print *,'5',(deltat/phi(n,j))*(sigmar(n,j+1)-0.d0)
        pause
        endif
c
cccccc     Begin the connection of nodes due to contact check
c
      do j=2,jj-2,2
        if ( ibc(j) .eq. -3 ) then
          print *,'Joining Nodes',j-2,' and ',j,' at n= ',n
          print *,'Before Joining:'
          print *,'The two nodes (VOID (left)and J(right)) at:'
          print *,'left: r(void,n-2)=',r(n,j-4),' U= ',U(n-1,j-4)
          print *,'VOID: r(void,n-2)=',r(n,j-2),' U= ',U(n-1,j-2)
          print *,'J:    r(j   ,n-2)=',r(n,j)  ,' U= ',U(n-1,j)
          print *,'right:r(j   ,n-2)=',r(n,j+2),' U= ',U(n-1,j+2)
          print *,'then stepped to:'
          print *,'left: r(-2  )=',r(n+2,j-4),' U= ',U(n+1,j-4)
          print *,'VOID: r(void)=',r(n+2,j-2),' U= ',U(n+1,j-2)
          print *,'J:    r(j   )=',r(n+2,j)  ,' U= ',U(n+1,j)
          print *,'right:r(+2  )=',r(n+2,j+2),' U= ',U(n+1,j+2)
          print *,'where they were joined'
                   ibc(j)   = 0
       Usave = (m(j+1)*U(n+1,j)+m(j-3)*U(n+1,j-2))
     &                      /(m(j-3)+m(j+1))
       print *,'Usave',usave,m(j+1),U(n+1,j),m(j-3),U(n+1,j-2)
     &                      ,m(j-3),m(j+1)
          do jjj = j-2,jj-2
           do nz = n,n+2
              ibc(    jjj  )  =    ibc(    jjj+2)
              ibc(    jjj+1)  =    ibc(    jjj+3)
             ieos(1,  jjj+1)  =   ieos(1,  jjj+3)
             ieos(2,  jjj+1)  =   ieos(2,  jjj+3)
                m(    jjj  )  =      m(    jjj+2)
              rho(    jjj+1)  =    rho(    jjj+3)

                r(nz ,jjj  )  =     r(nz ,jjj+2)
                U(nz ,jjj  )  =     U(nz ,jjj+2)
              phi(nz ,jjj  ) =    phi(nz ,jjj+2)
             beta(nz ,jjj  ) =   beta(nz ,jjj+2)
           sigmar(nz ,jjj+1) = sigmar(nz ,jjj+3)
           sigmao(nz ,jjj+1) = sigmao(nz ,jjj+3)
                V(nz ,jjj+1) =      V(nz ,jjj+3)
               s1(nz ,jjj+1) =     s1(nz ,jjj+3)
               s2(nz ,jjj+1) =     s2(nz ,jjj+3)
               s3(nz ,jjj+1) =     s3(nz ,jjj+3)
                E(nz ,jjj+1) =      E(nz ,jjj+3)
                Y(    jjj+1) =      Y(    jjj+3)
            pfrac(    jjj  ) =  pfrac(    jjj+2)  !node value
            pfrac(    jjj+1) =  pfrac(    jjj+3)  !Cell value
           enddo
          enddo
                U(n+1 ,j  -2) = Usave
             pfrac(    j  -2) = 1.d-2
c                Y(     j  -1) = 0.d0   !ie the materials are not welded after impact
c               r(n+2 ,j  -2) = r(n+1,j-2)+Usave*(t(n+2)-t(n+1))
c          if (abs(r(0,ipoint+j1(jjj-1))-xstart(jjj)) .lt. 1.e-5) then
c           Print *,'Warning:  Joined moved to same spot'
c          endif
              print *,'After Joining:'
              print *,'left: r(j-2)=',r(n+2,j-4),' U= ',u(n+1,j-4)
              print *,'New:  r(j) = ',r(n+2,j-2),' U= ',usave
              print *,'right:r(j+2)=',r(n+2,j  ),' U= ',u(n+1,j)
               pause
      do jzz=1,jj-2,2
       write(*,'(I4,5I2,3f7.3,2e9.3,5f7.3)')
     &  jzz,ieos(1,jzz),ieos(2,jzz),
     &  ibc(jzz-1),ibc(jzz),ibc(jzz+1),
     &  r(n+2,jzz-1),r(n+2,jzz),r(n+2,jzz+2),
     &  U(n+1,jzz-1),U(n+1,jzz+2),U(n+1,jzz+1)
c     &  ,v(n+2,jzz+1),m(jzz+1),rho(jzz+1),y(jzz+1),pfrac(jzz+2)
      enddo
      pause
        endif
      enddo
cccccccccccccccccccccc End of contact ccccccccccccccccccccccccccccc
c     Node passes it's neighbor check
c
      do j=2,jj-2,2
        if ( ibc(j) .ne. 9 .and. r(n+2,j) .lt. r(n+2,j-2) ) then
          print *,'Contact Check Failed',t(n),j
          print *,'Try lowering time step'
          print *,'Void',r(n+2,j-2),U(n+1,j-2)
          print *,'j   ',r(n+2,j)  ,U(n+1,j)
          print *,'deltat',deltat
          print *,bc(-1,1),bc(1,1)
          pause
       endif
      enddo
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     3.  Relative VOLUME   - within j
c
c      deltat     =  t(n+2)-t(n)
      do j=0,jj-2,2
      if (ibc(j+1) .eq. 0) then
c
        r(n+1,j+1) = ( r(n+1,j)+r(n+1,j+2) ) /2.d0
        r(n+2,j+1) = ( r(n+2,j)+r(n+2,j+2) ) /2.d0
c
        V(n+2,j+1)=rho(j+1)*((r(n+2,j+2)**d-r(n+2,j)**d)/d)/m(j+1)
        V(n+1,j+1)=rho(j+1)*((r(n+1,j+2)**d-r(n+1,j)**d)/d)/m(j+1)
c
      if ( V(n+2,j+1) .eq. 0.) then
      print *,'------------- Zero volume error! #1-----------------'
      print *,'volume',n,j+1,r(n+2,j+2),r(n+2,j),V(n+2,j+1)
      pause
      endif
      if ( V(n+1,j+1) .eq. 0.) then
      print *,'------------- Zero volume error! #2-----------------'
      print *,'volume',n,j+1,r(n+1,j+2),r(n+1,j),V(n+1,j+1)
      pause
      endif
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     4. VELOCITY STRAINS  - finish j
c
         epsi1(n+1,j+1) = (U(n+1,j+2)-U(n+1,j))/(r(n+1,j+2)-r(n+1,j))
        if (d .eq. 1.) then
         epsi2(n+1,j+1) = 0.d0
        else
         epsi2(n+1,j+1) = (U(n+1,j+2)+U(n+1,j))/(r(n+1,j+2)+r(n+1,j))
        endif
      endif

      enddo  ! end j loop for volume
        if (idebug .eq. 1 .and. n .ge. ndebug) then
        j=jdebug
        print *,'r',j,r(n+2,j+1),m(j+1)
        print *,'epsil',j,V(n+1,j+1),V(n+2,j+1),
     &                    epsi1(n+1,j+1),epsi2(n+1,j+1)
        pause
        endif
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     5a. STRESSES  - start j
c
      do j=0,jj-2,2
      if (ibc(j+1) .eq. 0) then
c       deltat = t(n+2)-t(n)
       s1(n+2,j+1) = s1(n,j+1) + 2.d0*eos(ieos(1,j+1),6)
     &             * ( epsi1(n+1,j+1)*deltat
     &                 - (V(n+2,j+1)-V(n,j+1))/(3.d0*V(n+1,j+1)) )
       s2(n+2,j+1) = s2(n,j+1) + 2.d0*eos(ieos(1,j+1),6)
     &             * ( epsi2(n+1,j+1)*deltat
     &                 - (V(n+2,j+1)-V(n,j+1))/(3.d0*V(n+1,j+1)) )
       s3(n+2,j+1) = -(s1(n+2,j+1)+s2(n+2,j+1))
c
       s1(n+1,j+1) = ( s1(n+2,j+1) + s1(n,j+1) )/2.d0
       s2(n+1,j+1) = ( s2(n+2,j+1) + s2(n,j+1) )/2.d0
       s3(n+1,j+1) = ( s3(n+2,j+1) + s3(n,j+1) )/2.d0
c
c
c
      endif
      enddo
        if (idebug .eq. 1 .and. n .ge. ndebug) then
      j=jdebug
      print *,'1',j,eos(ieos(1,j+1),6),V(n+2,j+1),V(n,j+1),V(n+1,j+1)
      print *,'s',s1(n+2,j+1),s2(n+2,j+1),s3(n+2,j+1),epsi1(n+1,j+1)
        endif
c      if (idebug .eq. 1 .and. n .ge. ndebug) pause
c
c     6. VON MISES YIELD CONDITION - start j
c
      do j=0,jj-2,2
      if (ibc(j+1) .eq. 0) then
      K(n+2,j+1) =(s1(n+2,j+1)**2 + s2(n+2,j+1)**2 + s3(n+2,j+1)**2)
     &           -(2.d0/3.d0)*Y(j+1)**2
       if (k(n+2,j+1) .gt. 0.) then
c       Print *,'material yielded',j,k(n+2,j+1)
c        pause
c        print *,s1(n+2,j+1),s2(n+2,j+1),s3(n+2,j+1)
         xx = sqrt(s1(n+2,j+1)**2 + s2(n+2,j+1)**2 + s3(n+2,j+1)**2)
         xx = sqrt(2.d0/3.d0)*Y(j+1)/xx
         s1(n+2,j+1) =   xx*s1(n+2,j+1)
         s2(n+2,j+1) =   xx*s2(n+2,j+1)
         s3(n+2,j+1) =   xx*s3(n+2,j+1)
         s1(n+1,j+1) = ( s1(n+2,j+1) + s1(n,j+1) )/2.d0
         s2(n+1,j+1) = ( s2(n+2,j+1) + s2(n,j+1) )/2.d0
         s3(n+1,j+1) = ( s3(n+2,j+1) + s3(n,j+1) )/2.d0
c
c        print *,s1(n+2,j+1),s2(n+2,j+1),s3(n+2,j+1)
c               if(idebug .eq. 1 )pause
       endif
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     7. ARTIFICIAL VISCOSITY - within j
c
       if (1 .eq. 1) then
       if(u(n+1,j+2) .lt. u(n+1,j)
     &  .and. V(n+2,j+1)-V(n,j+1) .lt. 0.
     &    ) then
        xx = rho(j+1)/V(n+1,j+1)
        if (p(n,j+1) .lt. 0.) then
c         print *,'Negative Pressure!'
         a  = sqrt(-P(n,j+1)/xx)
        else
         a  = sqrt( P(n,j+1)/xx)
        endif
        if (abs(P(n,j+1)) .lt. 0.002d0) a = 0.d0
c       print *,'Sound Speed',j,P(n,j+1),xx,a
        q(n+1,j+1) = Co*Co*xx*   (U(n+1,j+2)-U(n+1,j))**2
     &             + CL*a *xx*abs(U(n+1,j+2)-U(n+1,j))
       else
        q(n+1,j+1)=0.d0
       endif
      endif
      endif
      enddo
        if (idebug .eq. 1 .and. n .ge. ndebug) then
         j=jdebug
       print *,'Q',j,q(n+1,j+1),xx,(U(n+1,j+2)-U(n+1,j)),
     &    a,rho(j+1),v(n,j+1),P(n,j+1)
        endif
             if(idebug .eq.1 .and. n .ge. ndebug) pause
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     8.  ENERGY  - start j
c     iEOS(2,imat)=1 - Mie Grunisen
c     iEOS(2,imat)=2 - Gamma law ideal gas
c     iEOS(2,imat)=3 - Gamma law ideal gas     ???
c     iEOS(2,imat)=4 - snow plow model with KO inputs for Hugoniot
c     iEOS(2,imat)=5 - snow plow model with anamolous hugoniot
c
c
      do j=0,jj-2,2
      if (ibc(j+1) .eq. 0) then
       if (iEOS(2,j+1) .eq. 1) then                    !Mie Grunisen
        qbar = (q(n+1,j+1)+q(n-1,j+1))/2.d0
        deltaZ = V(n+1,j+1)*(s1(n+1,j+1)*epsi1(n+1,j+1)
     &             +(d-1.d0)*s2(n+1,j+1)*epsi2(n+1,j+1))*deltat
        xx = 1.d0 - V(n+2,j+1)
        xb = eos(ieos(1,j+1),4) !gamma
        if(xx .lt. 0.) then
        xa = eos(ieos(1,j+1),1)*xx+0.d0*xx**2+eos(ieos(1,j+1),3)*xx**3
        else
        xa = eos(ieos(1,j+1),1)*xx+eos(ieos(1,j+1),2)*xx**2
     &      +eos(ieos(1,j+1),3)*xx**3
        endif
        E(n+2,j+1)=
     &  ( E(n,j+1)-((xa+P(n,j+1))/2.d0+ qbar)*(V(n+2,j+1)-V(n,j+1))
     &            + deltaZ )
     &   / (1.d0 + xb*(V(n+2,j+1)-V(n,j+1))/2.d0)
        E(n+1,j+1)= ( E(n+2,j+1) + E(n,j+1) )/2.d0
c      if (n .eq. 33) then
c        write (*,'(a2,I3,9e9.2)')
c     &   'E ',j,E(n+2,j+1),E(n+2,j+1),xa,P(n,j+1),qbar,deltaZ
c     &   ,V(n+2,j+1),V(n,j+1)
cc      pause
c      endif
       elseif (iEOS(2,j+1) .eq. 2) then                !Gamma law ideal gas
        qbar   = (q(n+1,j+1)+q(n-1,j+1))/2.d0
        delt   = t(n+1)-t(n)
        deltaZ = V(n+1,j+1)*(s1(n+1,j+1)*epsi1(n+1,j+1)
     &              +(d-1.d0)*s2(n+1,j+1)*epsi2(n+1,j+1))*delt
c
        xa   = 0.d0
        xb   = (eos(ieos(1,j+1),4)-1.d0)/V(n+2,j+1)  !gamma
        E(n+2,j+1)= ( E(n,j+1)
     &   -((xa+P(n,j+1))/2.d0+ qbar)*(V(n+2,j+1)-V(n,j+1)) + deltaZ )/
     &  (1.d0+xb*(V(n+2,j+1)-V(n,j+1))/2.d0)
c      if (j .eq. 0 ) then
c        if (n .lt.2. .or. n .eq. 201)    E(n+2,j+1)=0.d0
c        xx=V(n+2,j+1)-V(n,j+1)
c        print *,E(n,j+1)   /(1.*(1.+xb*(V(n+2,j+1)-V(n,j+1))/2.))
c        print *,xa*xx      /(2.*(1.+xb*(V(n+2,j+1)-V(n,j+1))/2.))
c        print *,P(n,j+1)*xx/(2.*(1.+xb*(V(n+2,j+1)-V(n,j+1))/2.))
c        print *,qbar*xx    /(1.*(1.+xb*(V(n+2,j+1)-V(n,j+1))/2.))
c        print *,deltaZ  /(1.*(1.+xb*(V(n+2,j+1)-V(n,j+1))/2.))
c      endif
       elseif (iEOS(2,j+1) .eq. 3) then                !Gamma law ideal gas     ???
        qbar = (q(n+1,j+1)+q(n-1,j+1))/2.d0
        delt   = t(n+1)-t(n)
        deltaZ = V(n+1,j+1)*(s1(n+1,j+1)*epsi1(n+1,j+1)
     &              +(d-1.0d0)*s2(n+1,j+1)*epsi2(n+1,j+1))*delt
c
        xx   = rho(j+1)/V(n+2,j+1)
        xa   = 0.d0
        xb   = (eos(ieos(1,j+1),4)-1.d0)/V(n+2,j+1)
        E(n+2,j+1)=
     &   ( E(n,j+1)
     &   -((xa+P(n,j+1))/2.d0+ qbar)*(V(n+2,j+1)-V(n,j+1))+ deltaZ )/
     &  (1.d0+xb*(V(n+2,j+1)-V(n,j+1))/2.d0)
       elseif (iEOS(2,j+1) .eq. 4) then                !Snow Plow
        qbar = (q(n+1,j+1)+q(n-1,j+1))/2.d0
        deltaZ = V(n+1,j+1)*(s1(n+1,j+1)*epsi1(n+1,j+1)
     &             +(d-1.d0)*s2(n+1,j+1)*epsi2(n+1,j+1))*deltat
        xb = eos(ieos(1,j+1),4) !gamma
        v0 = eos(ieos(1,j+1),8)
        xx = 1.d0 - (V(n+2,j+1)/rho(j+1))/V0   !this makes the compression relative to the compacted material hugoniot
        if ( v(n+2,j+1)/rho(j+1) .le. v0) icompact(n+2,j+1) = 1
        if(     icompact(n+2,j+1) .eq. 1 .and. xx .lt. 0.d0) then
         xa = eos(ieos(1,j+1),1)*xx+eos(ieos(1,j+1),3)*xx**3
        elseif (icompact(n+2,j+1) .eq. 1 .and. xx .ge. 0.d0) then
         xa = eos(ieos(1,j+1),1)*xx+eos(ieos(1,j+1),2)*xx**2
     &       +eos(ieos(1,j+1),3)*xx**3
        elseif( icompact(n+2,j+1) .eq. 0) then
         xa = 0.d0   !snow plow model - this zeros out pressure until threshold density is reached
        else
         print *,'compaction error in energy'
         print *,icompact(n+2,j+1),xx
         pause
        endif
        E(n+2,j+1)=
     &  ( E(n,j+1)-((xa+P(n,j+1))/2.d0+ qbar)*(V(n+2,j+1)-V(n,j+1))
     &            + deltaZ )
     &   / (1.d0 + xb*(V(n+2,j+1)-V(n,j+1))/2.d0)
        E(n+1,j+1)= ( E(n+2,j+1) + E(n,j+1) )/2.d0
       elseif (iEOS(2,j+1) .eq. 5) then                !Snow Plow with anaomolus hugoniot
        qbar = (q(n+1,j+1)+q(n-1,j+1))/2.d0
        deltaZ = V(n+1,j+1)*(s1(n+1,j+1)*epsi1(n+1,j+1)
     &             +(d-1.d0)*s2(n+1,j+1)*epsi2(n+1,j+1))*deltat
        stemp = 0.1048d0      !slope
        ctemp = 0.5124d0      !bulk sound speed
        gtemp = 0.9d0         !gamma
        v0 = eos(ieos(1,j+1),8)
        V00= 1.d0/rho(j+1)
        vv = V(n+2,j+1)/rho(j+1)    !v_local
        if ( v(n+2,j+1)/rho(j+1) .le. v0) icompact(n+2,j+1) = 1
        if (icompact(n+2,j+1) .eq. 1) then  !icompact is the flag, once compact always compact
         xa = ((2.d0*vv-gtemp*(v0 -vv))*ctemp*ctemp*(v0-vv))     !porous hugoniot, see meyers pg 141
     &       /((2.d0*vv-gtemp*(v00-vv))*((v0-stemp*(v0-vv))**2) )
         xa = dabs(xa) !not sure if i need this but it was add so that re-denstended materials don't have negative pressure
        else
         xa = 0.d0
        endif
        E(n+2,j+1)=
     &  ( E(n,j+1)-((xa+P(n,j+1))/2.d0+ qbar)*(V(n+2,j+1)-V(n,j+1))
     &            + deltaZ )
     &   / (1.d0 + xb*(V(n+2,j+1)-V(n,j+1))/2.d0)
        E(n+1,j+1)= ( E(n+2,j+1) + E(n,j+1) )/2.d0
       else
        print *,'EOS error!'
        print *,n,j,ieos(2,j+1)
        pause
       endif
      endif

      enddo

      if(idebug .eq.1  .and. n .ge. ndebug) then
        j=jdebug
        print *,'Energy',j,E(n+2,j+1),E(n,j+1),xx,
     & (2.d0*(1.d0+xb*(V(n+2,j+1)-V(n,j+1))/2.d0))
      endif
             if(idebug .eq.1  .and. n .gt. ndebug) pause
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     5b PRESSURE - start j
c
      do j = 0,jj-2,2
      if (ibc(j+1) .eq. 0) then
       if (iEOS(2,j+1) .eq. 1) then
        xx         = 1.d0 - V(n+1,j+1)
        if (xx .lt. 0.) then
         P(n+1,j+1) = eos(ieos(1,j+1),1)*xx+
     &                eos(ieos(1,j+1),3)*xx**3+
     &                eos(ieos(1,j+1),4)*E(n+1,j+1)
        else
         P(n+1,j+1) = eos(ieos(1,j+1),1)*xx+
     &                eos(ieos(1,j+1),2)*xx**2+
     &                eos(ieos(1,j+1),3)*xx**3+
     &                eos(ieos(1,j+1),4)*E(n+1,j+1)
        endif
        xx         = 1.d0 - V(n+2,j+1)
        if (xx .lt. 0.) then
         P(n+2,j+1) = eos(ieos(1,j+1),1)*xx+
     &                eos(ieos(1,j+1),3)*xx**3+
     &                eos(ieos(1,j+1),4)*E(n+2,j+1)
        else
         P(n+2,j+1) = eos(ieos(1,j+1),1)*xx+
     &                eos(ieos(1,j+1),2)*xx**2+
     &                eos(ieos(1,j+1),3)*xx**3+
     &                eos(ieos(1,j+1),4)*E(n+2,j+1)
        endif
c       if (icontact .eq. 1) then
c       if (P(n+2,j+1) .lt. 0.) then
c       print *,'Neg Pres',n+1,j+1,xx,v(n+1,j+1),E(n+1,j+1),p(n+1,j+1)
c       print *,'Neg Pres',n+2,j+1,xx,v(n+2,j+1),E(n+2,j+1),p(n+2,j+1)
cc       pause
c       endif
c       endif
       elseif (iEOS(2,j+1) .eq. 2) then
c       p_1 = V_0*rho_0*(U_1-U_0)**2/(V_0-V_1)+P_0
c       print *,'Mass and Momentum Pressure',P_1
c      E_1 = E_0+(P_1 + P_0)*(V_0-V_1)/2.
c      P_1 = 2.*(E_1-E_0)/(V_0-V_1)-P_0
c
         P(n+2,j+1) = (eos(ieos(1,j+1),4)-1.d0)*E(n+2,j+1)/V(n+2,j+1)
         P(n+1,j+1) = (P(n,j+1)+P(n+2,j+1))/2.d0
       elseif (ieos(2,j+1) .eq. 3) then
        xa          = (u(n+2,j)+u(n+2,j+2))/2.d0
        xx          = rho(j+1)/V(n+2,j+1)
         P(n+2,j+1) = P(n,j+1)
     &     +(eos(ieos(1,j+1),4)+1.d0)*xx*xa*xa/2.d0
c       print *,'pres',rho_0,gamma+1,xa,xx
       elseif (ieos(2,j+1) .eq. 4) then         !Snow Plow
        v0  = eos(ieos(1,j+1),8)
        V00 = 1.d0/rho(j+1)
        vv  = v(n+1,j+1)/rho(j+1)
        if (v0 .eq. 0.) then
         print *,'v0 can not equal zero'
         print *,j,ieos(1,j+1),eos(ieos(1,j+1),8)
         pause
        endif
c
        if (vv .le. V0) icompact(n+1,j+1) = 1
         xx         = 1.d0 - (V(n+1,j+1)/rho(j+1))/V0   !this makes the compression relative to the compacted material hugoniot
        if (icompact(n+1,j+1) .eq. 1 .and. xx .lt. 0.) then
          P(n+1,j+1) = eos(ieos(1,j+1),1)*xx+
     &                 eos(ieos(1,j+1),3)*xx**3+
     &                 eos(ieos(1,j+1),4)*E(n+1,j+1)
        elseif(icompact(n+1,j+1) .eq. 1 .and. xx .ge. 0.d0) then
          P(n+1,j+1) = eos(ieos(1,j+1),1)*xx+
     &                 eos(ieos(1,j+1),2)*xx**2+
     &                 eos(ieos(1,j+1),3)*xx**3+
     &                 eos(ieos(1,j+1),4)*E(n+1,j+1)
        elseif (icompact(n+1,j+1) .eq. 0) then
          P(n+1,j+1) = 0.d0*eos(ieos(1,j+1),4)*E(n+1,j+1)
        else
         Print *,'pressure compaction error'
         pause
        endif
c        if ( icompact(n+1,j+1) .eq. 1) then
c        print *,t(n),j+1,icompact(n+1,j+1),vv,p(n+1,j+1)
c        print *,eos(ieos(1,j+1),1)*xx,eos(ieos(1,j+1),3)*xx**3
c     &         ,eos(ieos(1,j+1),4)*E(n+1,j+1)
c        print *,xx,eos(ieos(1,j+1),1),eos(ieos(1,j+1),3)
c     &         ,eos(ieos(1,j+1),4)
c        pause
c        else
c        print *,t(n),j+1,icompact(n+1,j+1),vv,p(n+1,j+1)
c        endif
c
        if (v(n+2,j+1)/rho(j+1) .le. V0) icompact(n+2,j+1) = 1
         xx         = 1.d0 - (V(n+2,j+1)/rho(j+1))/V0     !this makes the compression relative to the compacted material hugoniot
         if (icompact(n+2,j+1) .eq. 1 .and. xx .lt. 0.) then
          P(n+2,j+1) = eos(ieos(1,j+1),1)*xx+
     &                 eos(ieos(1,j+1),3)*xx**3+
     &                 eos(ieos(1,j+1),4)*E(n+2,j+1)
         elseif (icompact(n+2,j+1) .eq. 1 .and. xx .ge. 0.) then
          P(n+2,j+1) = eos(ieos(1,j+1),1)*xx+
     &                 eos(ieos(1,j+1),2)*xx**2+
     &                 eos(ieos(1,j+1),3)*xx**3+
     &                 eos(ieos(1,j+1),4)*E(n+2,j+1)
        elseif (icompact(n+2,j+1) .eq. 0) then  !v .gt. v0
          P(n+2,j+1) = 0.d0*eos(ieos(1,j+1),4)*E(n+2,j+1)
        else
         Print *,'pressure compaction error'
         pause
        endif
c
       elseif (ieos(2,j+1) .eq. 5) then   ! Snow Plow with anaomolous Hugoniot
         V0 = eos(ieos(1,j+1),8)
         V00= 1.d0/rho(j+1)

         vv = V(n+1,j+1)/rho(j+1)    !v_local
         if (VV .le. V0) icompact(n+1,j+1) = 1
         if (icompact(n+1,j+1) .eq. 1) then
          xa = ((2.d0*vv-gtemp*(v0 -vv))*ctemp*ctemp*(v0-vv))     !porous hugoniot, see meyers pg 141
     &        /((2.d0*vv-gtemp*(v00-vv))*((v0-stemp*(v0-vv))**2) )
          if (xa .lt. 0.d0) then
           print *,'Compression less than v0 on anamolous hugoniot, n+1'
           xa=dabs(xa)
          endif
         else
          xa = 0.d0
         endif
         
         P(n+1,j+1) = xa + eos(ieos(1,j+1),4)*E(n+1,j+1)

         vv = V(n+2,j+1)/rho(j+1)    !v_local
         if (VV .le. V0) icompact(n+2,j+1) = 1
         if (icompact(n+2,j+1) .eq. 1) then
         xa = ((2.d0*vv-gtemp*(v0 -vv))*ctemp*ctemp*(v0-vv))     !porous hugoniot, see meyers pg 141
     &       /((2.d0*vv-gtemp*(v00-vv))*((v0-stemp*(v0-vv))**2) )
          if (xa .lt. 0.d0) then
           print *,'Compression less than v0 on anamolous hugoniot, n+2'
           xa=dabs(xa)
          endif
         else
          xa = 0.d0
         endif
      else    !this is ieos(2,j+1) else
      Print *,'eos error in setup file'
      pause
      endif  ! IEOS
      endif !ibc
      enddo
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Check for tensile fracture, ie does the pressure/stress exceed pfrac at j?
c     check for physical separation
c
      if (1 .eq. 0) then
      do j=0,jj-2,2
       if (-p(n+2,j+1)+s1(n+2,j+1) .gt. pfrac(j)) then
        print *,j,n,-p(n+2,j+1)+s1(n+2,j+1),pfrac(j)
        print *,"Tensile Fracture!!"
        print *,'Separating Node',j,' at n= ',n
        print *,'Before Separating:'
        print *,'The node at:'
        print *,'left: r(j-2 ,n+2)=',r(n+2,j-2),' U(n-1)=',U(n+1,j-2)
        print *,'J:    r(j   ,n+2)=',r(n+2,j)  ,' U(n-1)=',U(n+1,j+0)
        print *,'right:r(j+2 ,n+2)=',r(n+2,j+2),' U(n-1)=',U(n+1,j+2)
        print *,'      r(j+4 ,n+2)=',r(n+2,j+4),' U(n-1)=',U(n+1,j+4)
       print *,'Frac',-p(n+2,j+1)+s1(n+2,j+1),pfrac(j)
        do jjj = jj-4,j+2,-2
         do nz = n,n+2
              ibc(    jjj-0)  =    ibc(    jjj-2)
              ibc(    jjj-1)  =    ibc(    jjj-3)
             ieos(1,  jjj-1)  =   ieos(1,  jjj-3)
             ieos(2,  jjj-1)  =   ieos(2,  jjj-3)
             ieos(1,  jjj-0)  =   ieos(1,  jjj-2)
             ieos(2,  jjj-0)  =   ieos(2,  jjj-2)
                m(    jjj-1)  =      m(    jjj-3)
              rho(    jjj-1)  =    rho(    jjj-3)

                r(nz ,jjj-0)  =     r(nz ,jjj-2)
                r(nz ,jjj-1)  =     r(nz ,jjj-3)
                U(nz ,jjj-0)  =     U(nz ,jjj-2)
              phi(nz ,jjj-0) =    phi(nz ,jjj-2)
             beta(nz ,jjj-0) =   beta(nz ,jjj-2)
           sigmar(nz ,jjj-1) = sigmar(nz ,jjj-3)
           sigmao(nz ,jjj-1) = sigmao(nz ,jjj-3)
                V(nz ,jjj-1) =      V(nz ,jjj-3)
               s1(nz ,jjj-1) =     s1(nz ,jjj-3)
               s2(nz ,jjj-1) =     s2(nz ,jjj-3)
               s3(nz ,jjj-1) =     s3(nz ,jjj-3)
                q(nz ,jjj-1) =      q(nz ,jjj-3)
            epsi1(nz ,jjj-1) =  epsi1(nz ,jjj-3)
            epsi2(nz ,jjj-1) =  epsi2(nz ,jjj-3)
                E(nz ,jjj-1) =      E(nz ,jjj-3)
                Y(    jjj-1) =      Y(    jjj-3)
                k(nz ,jjj-1) =      k(nz ,jjj-3)
            pfrac(    jjj-0) =  pfrac(    jjj-2)  !node value
            pfrac(    jjj-1) =  pfrac(    jjj-3)  !Cell value
           enddo
          enddo
c
          do nz = n,n+2  !void cell center
                 U(nz,j+1) = zero
                 U(nz,j+1) = zero
              phi(nz ,j+1) = zero
             beta(nz ,j+1) = zero
           sigmar(nz ,j+1) = zero
           sigmao(nz ,j+1) = zero
                V(nz ,j+1) = zero
               s1(nz ,j+1) = zero
               s2(nz ,j+1) = zero
               s3(nz ,j+1) = zero
                E(nz ,j+1) = zero
                Y(    j+1) = zero
                q(nz ,j+1) = zero
            pfrac(    j+1) = zero
            pfrac(    j+1) = zero
          enddo
                ibc(j)   = 2 !outer
                ibc(j+1) = 9 !void
                ibc(j+2) =-2 !inner
              P(n+1,j+1) = pvoid
              P(n+2,j+1) = pvoid
              P(n+1,j-1) = pvoid
              P(n+2,j-1) = pvoid
              P(n+1,j+3) = pvoid
              P(n+2,j+3) = pvoid
              u(n+1,j+2) = u(n+1,j+4)
              r(n+1,j+1) = r(n+1,j)
              r(n+2,j+1) = r(n+2,j)
              pfrac(j+2) =  pfrac(j+4)  !node value
              pfrac(j+3) =  pfrac(j+4)  !node value
        print *,'After Separating:',n,j
        print *,'r(j-2)=',r(n+2,j-2),'U= ',u(n+1,j-2),'P=',P(n+2,j-2)
        print *,'r(j-1)=',r(n+2,j-1),'U= ',u(n+1,j-1),'P=',P(n+2,j-1)
        print *,'r(j)  =',r(n+2,j  ),'U= ',u(n+1,j-0),'P=',P(n+2,j+0)
        print *,'r(j+1)=',r(n+2,j+1),'U= ',u(n+1,j+1),'P=',P(n+2,j+1)
        print *,'r(j+2)=',r(n+2,j+2),'U= ',u(n+1,j+2),'P=',P(n+2,j+2)
        print *,'r(j+3)=',r(n+2,j+3),'U= ',u(n+1,j+3),'P=',P(n+2,j+3)
        print *,'r(j+4)=',r(n+2,j+4),'U= ',u(n+1,j+4),'P=',P(n+2,j+4)
               pause
c
      do jzz=1,jj-2,1
c       write(*,'(I4,5I2,10f7.3)')
       write(*,'(I4,5I2,3f7.3,2e11.3,5f7.3)')
     &  jzz,ieos(1,jzz),ieos(2,jzz),
     &  ibc(jzz-1),ibc(jzz),ibc(jzz+1),
     &  r(n+2,jzz-1),r(n+2,jzz),r(n+2,jzz+1),
     &  U(n+1,jzz-1),U(n+1,jzz),U(n+1,jzz+1),
     &  p(n+2,jzz)
c     &  ,v(n+2,jzz+1),m(jzz+1),rho(jzz+1),y(jzz+1),pfrac(jzz+2)
      enddo
      pause
        endif
      enddo ! this is the fracture check
      endif
c
c**************************************************************
c       TIME-STEP
c
       dt_min =  1.d9
       dr_min   =  r(n+2,0+2)-r(n+2,0  )  !this is just to get us started
c
       jzz    = -1
      do j = 0, jj-2, 2
      if (ibc(j+1) .eq. 0) then
c       deltat =     t(n+2)    -t(n)
       Vdot   =   ( V(n+2,j+1)-V(n  ,j+1) )/deltat
       deltar = abs(r(n+2,j+2)-r(n+2,j  ) )
c
       b      = 8.d0*(Co**2+CL)*deltar*(Vdot/V(n+1,j+1))
       if (Vdot/V(n+1,j+1) .ge. 0.) b = 0.d0
c
       rho_local = rho(j+1)/V(n+2,j+1)
c       print *,'rho_local',j,rho_local,rho(j+1),1.d0/v(n+2,j+1)
       if (rho_local .gt. 1.e10) then
       print *,'Error: density too high'
       print *,j,ndummy,t(n)
       print *,rho(j+1),v(n+2,j+1)
       print *,j,r(n+2,j+2),r(n+2,j)
       print *,V(n+2,j+1),V(n,j+1)
       print *,P(n+1,j),p(n+1,j+1),P(n+2,j),p(n+2,j+1)
       pause
       endif
c       print *,'rho local',rho_local
       a  = sqrt(abs(P(n+2,j+1))/ rho_local ) !I checked units
c       print *,'ts',j,a,b,deltar,Vdot,V(n+1,j+1)
       if ( (a**2+b**2) .ne. 0.d0 ) then
        delt_temp = (2.d0/3.d0)*(deltar/sqrt(a**2+b**2))
        if (delt_temp .lt. dt_min) then
         jzz    = j
         dt_min = delt_temp
         a_min = a
         b_min = b
         rho_min=rho_local
c        print *,'rr',rho_min,deltat,jzz,a_min,b_min,p(n+2,j+1)
c        pause
        endif
       endif
       endif !ibc(j+1)
      enddo !j loop

      dt_min=dt_min/5.d0    !Here is where you can arbitrarly lower time step
                            !the demomenator is suppose to be 1.d0
      delt = t(n+1)-t(n-1)
      if (dt_min .gt. 1.1d0*delt ) then
        dt_min = 1.1d0 * delt
      endif
      deltat = (dt_min+delt)/2.d0
c
c      t(n+3) = t(n+2) + deltat           ! this is now advanced along with all the
c      t(n+4) = t(n+2) + deltat + deltat  ! other state variables
c
      if (idebug .eq. 1) then
      if (icontact .eq. 1) then
      Print *,'End of first contact'
             if(idebug .eq.1 )pause
      endif
      endif
c        if (deltat .lt. 0.1d-5) then  ! this is just larry swabies suggestion for stability
c        print *,rho_min,deltat,jzz,a_min,b_min
c        endif

c*******************OUTPUT SOLUTION to Screen**********************
c
      if (idebug .eq. 1 .and. ndummy .gt. ndebug) then
      do j = 1,jj-2,2
        write(*,'(2I4,11f7.4)')
     & n+1,j,t(n),r(n+1,j-1),r(n+1,j+1),U(n+1,j-1),U(n+1,j+1)
     &,P(n+2,j),q(n+2,j),e(n+2,j),V(n+2,j)
      enddo
      pause
      endif
c
      jzz = ndummy
      if (int((jzz-1)/iskip) .eq. dfloat(jzz-1)/dfloat(iskip) .or.
     &                t(n+2) .ge. tstop) then
c      if (n .eq. 1 .or. t(n) .ge. tskip ) then
      qtotal  = 0.d0
      mvtotal = 0.d0
      etotal  = 0.d0
c
      do j = 0,jj-2,2
       if (ibc(j+1) .eq. 0) then
       qtotal  = qtotal  +  q(n+2,j)
       mvtotal = mvtotal +  m(j+1)*( u(n+1,j) + u(n+1,j+2) )/2.d0
       etotal  = etotal  +  (E(n+2,j+1)-E(n,j+1))/deltat
     &         + P(n+1,j+1)*(V(n+2,j+1)-V(n,j+1))/deltat
       endif
      enddo

        write(*,'(1I7,5e13.5)')
     & ndummy,deltat,t(n),mvtotal,etotal,qtotal

c       ioffset = 10
c       do j=98-ioffset,98,2
c         write(*,99)
c     & n+2,j+1,t(n),r(n+1,j),r(n+1,j+2),U(n+1,j),U(n+1,j+2)
c     &  ,P(n+2,j+1),e(n+2,j+1),q(n+1,j+1)
c       enddo
c       do j=98,98+ioffset,2
c         write(*,99)
c     & n+2,j+1,t(n),r(n+1,j),r(n+1,j+2),U(n+1,j),U(n+1,j+2)
c     &  ,P(n+2,j+1),e(n+2,j+1),q(n+1,j+1)
c       enddo
c      print *, ' '
c
c      skip = (jj/2)/256
c      skip = nn/skip
c      do j=ioffset,nn,skip
c      write(*,98)
c     &'n','Cell','dt','rad','rad','Vel','Vel'
c     &,'pres','Vol'
c      print *,' '
c      enddo
c      write(*,'(2I4,6e9.2,6f7.4)')
c     & n,j,deltat,r(n,j-1),r(n,j+1),U(n,j-1),U(n,j+1),P(n,j)
c     & ,V(n,j),rho(j)
      endif
c
c ******************* Write solution to File  *************************
c       write(*,*) 'Enter file name'
c       read(*,*) name
c       name='al.txt'
c       open (unit=33, file=name, form='formatted', status='unknown')
c       do n=1,nn,2
      if (t(n) .eq. 0. .or. t(n) .ge. tskip ) then
          do j=0,jj-4,2
         bs1 = V(n  ,j+1)/rho(j+1)
         bs2 = U(n-1,j  )
         bs3 = P(n  ,j+1)
         bs4 = E(n  ,j+1)
         bs5 = q(n-1,j+1)
         bs6 = s1(n  ,j+1)
         bs7 = s2(n  ,j+1)
         bs8 = epsi1(n-1,j+1)

         if (abs(V(n  ,j+1))     .lt. 1.d-99)   bs1 = 0.d0  !this is because if the expoent is
         if (abs(U(n-1,j  ))     .lt. 1.d-99)   bs2 = 0.d0  ! larger than 99 it will not write
         if (abs(P(n  ,j+1))     .lt. 1.d-99)   bs3 = 0.d0  ! to the file correctly, so I just
         if (abs(E(n  ,j+1))     .lt. 1.d-99)   bs4 = 0.d0  ! zero it out
         if (abs(q(n-1,j+1))     .lt. 1.d-99)   bs5 = 0.d0
         if (abs(s1(n  ,j+1))    .lt. 1.d-99)   bs6 = 0.d0
         if (abs(s2(n  ,j+1))    .lt. 1.d-99)   bs7 = 0.d0
         if (abs(epsi1(n-1,j+1)) .lt. 1.d-99)   bs8 = 0.d0
         bs9 = -bs3 + bs6

c      epsi1(n+1,j+1) = (U(n+1,j+2)-U(n+1,j))/(r(n+1,j+2)-r(n+1,j))
c      epsi2(n+1,j+1)
            write(33,'(2I6,3I3,15d26.18)')
     &     n,j+1,ibc(j),ibc(j+1),ibc(j+2),t(n),r(n,j),r(n,j+1),r(n,j+2)
     &      ,bs1,bs2,bs3,rho(j+1),
     &       bs4,bs5,bs6,bs7,k(n,j+1),bs8,bs9
      enddo  ! this is j loop
      tskip = tskip + dtskip
      endif
c
cccccccccccccccccccccc Update solution ccccccccccccccccccccccccccccc
c
      do j=0,jj
      if (ibc(j) .ne. 9) then
c
        U(n-1,j)       = U(n+1,j)
        U(n  ,j)       = U(n+2,j)
        phi(n-1,j)     = phi(n+1,j)
        phi(n  ,j)     = phi(n+2,j)
        sigmar(n-1,j)  = sigmar(n+1,j)
        sigmar(n  ,j)  = sigmar(n+2,j)
        sigmao(n-1,j)  = sigmao(n+1,j)
        sigmao(n  ,j)  = sigmao(n+2,j)
        beta(n-1,j)    = beta(n+1,j)
        beta(n  ,j)    = beta(n+2,j)
        V(n-1,j)       = V(n+1,j)
        V(n  ,j)       = V(n+2,j)
        r(n-1,j)       = r(n+1,j)
        r(n  ,j)       = r(n+2,j)
        epsi1(n-1,j)   = epsi1(n+1,j)
        epsi1(n  ,j)   = epsi1(n+2,j)
        epsi2(n-1,j)   = epsi2(n+1,j)
        epsi2(n  ,j)   = epsi2(n+2,j)
        s1(n-1,j)      = s1(n+1,j)
        s1(n  ,j)      = s1(n+2,j)
        s2(n-1,j)      = s2(n+1,j)
        s2(n  ,j)      = s2(n+2,j)
        s3(n-1,j)      = s3(n+1,j)
        s3(n  ,j)      = s3(n+2,j)
        P(n-1,j)       = P(n+1,j)
        P(n  ,j)       = P(n+2,j)
        q(n-1,j)       = q(n+1,j)
        q(n  ,j)       = q(n+2,j)
        t(n-1)         = t(n+1)
        t(n  )         = t(n+2)
        E(n-1,j)       = E(n+1,j)
        E(n  ,j)       = E(n+2,j)
        K(n-1,j)       = K(n+1,j)
        K(n  ,j)       = K(n+2,j)
        icompact(n-1,j)= icompact(n+1,j)
        icompact(n  ,j)= icompact(n+2,j)

      endif
      enddo
cccccccccccccccccccccc  Main loop closed ccccccccccccccccccccccccccccccccccccc
       if (t(n) .le. tstop) goto 1
c      enddo  ! n or time loop
       close(33)
      print *,'*******************  Finished!!  ******************'
       pause
       end
